<?php
/*
* Author: onlinecode
* start Pdf.php file
* Location: ./application/libraries/Pdf.php
*/
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once dirname(__FILE__) . '/tcpdf/tcpdf.php';
class Pdf extends TCPDF
{
function __construct()
{
parent::__construct();
$CI = & get_instance();
    $CI->load->model('ConfigModels');
    $this->InfoEmpresa = $CI->ConfigModels->Value("InfoEmpresa");
  
}

public function Header() {
    $bMargin = $this->getBreakMargin();
    // get current auto-page-break mode
    $auto_page_break = $this->AutoPageBreak;
    // disable auto-page-break
    $this->SetAutoPageBreak(false, 0);
    // set bacground image
    $this->Image(K_PATH_IMAGES."Logo3.png", 12, 60, 180);
    // print an ending header line
    $this->SetAutoPageBreak($auto_page_break, $bMargin);
    // set the starting point for the page content
    $this->setPageMark();
    if ($this->header_xobjid === false) {
        // start a new XObject Template
        $this->header_xobjid = $this->startTemplate($this->w, $this->tMargin);
        $headerfont = $this->getHeaderFont();
        $headerdata = $this->getHeaderData();
        $this->y = $this->header_margin;
        if ($this->rtl) {
            $this->x = $this->w - $this->original_rMargin;
        } else {
            $this->x = $this->original_lMargin;
        }
        if (($headerdata['logo']) AND ($headerdata['logo'] != K_BLANK_IMAGE)) {
            $imgtype = TCPDF_IMAGES::getImageFileType(K_PATH_IMAGES.$headerdata['logo']);
            if (($imgtype == 'eps') OR ($imgtype == 'ai')) {
                $this->ImageEps(K_PATH_IMAGES.$headerdata['logo'], '', '', $headerdata['logo_width']);
            } elseif ($imgtype == 'svg') {
                $this->ImageSVG(K_PATH_IMAGES.$headerdata['logo'], '', '', $headerdata['logo_width']);
            } else {
                $this->Image(K_PATH_IMAGES.$headerdata['logo'], '', '', $headerdata['logo_width']);
            }
            $imgy = $this->getImageRBY();
        } else {
            $imgy = $this->y;
        }
        /// nose
      if (($headerdata['logo']) AND ($headerdata['logo'] != K_BLANK_IMAGE)) {
        $imgtype = TCPDF_IMAGES::getImageFileType(K_PATH_IMAGES.$headerdata['logo']);
        if (($imgtype == 'eps') OR ($imgtype == 'ai')) {
            $this->ImageEps(K_PATH_IMAGES."Logo2.png", $this->k,'', $headerdata['logo_width']);
        } elseif ($imgtype == 'svg') {
            $this->ImageSVG(K_PATH_IMAGES."Logo2.png", $this->k, '', $headerdata['logo_width']);
        } else {
            $this->Image(K_PATH_IMAGES."Logo2.png", 170, "", 30);
        }
        $imgy = $this->getImageRBY();
    } else {
        $imgy = $this->y;
    }
    //fin nose
        $cell_height = $this->getCellHeight($headerfont[2] / $this->k);
        // set starting margin for text data cell
        if ($this->getRTL()) {
            $header_x = $this->original_rMargin + ($headerdata['logo_width'] * 1.1);
        } else {
            $header_x = $this->original_lMargin + ($headerdata['logo_width'] * 1.1);
        }
        $cw = $this->w - $this->original_lMargin - $this->original_rMargin - ($headerdata['logo_width'] * 1.1);
        $this->SetTextColorArray($this->header_text_color);
        // header title
        $this->SetFont($headerfont[0], 'B', $headerfont[2] + 1);
        $this->SetX($header_x);
        $this->Cell($cw, $cell_height, $headerdata['title'], 0, 1, '', 0, '', 0);
        // header string
        $this->SetFont($headerfont[0], $headerfont[1], $headerfont[2]);
        $this->SetX($header_x);
        $this->MultiCell($cw, $cell_height, $headerdata['string'], 0, '', 0, 1, '', '', true, 0, false, true, 0, 'T', false);
      



     

      
     
    }
    // print header template
    $x = 0;
    $dx = 0;
    if (!$this->header_xobj_autoreset AND $this->booklet AND (($this->page % 2) == 0)) {
        // adjust margins for booklet mode
        $dx = ($this->original_lMargin - $this->original_rMargin);
    }
    if ($this->rtl) {
        $x = $this->w + $dx;
    } else {
        $x = 0 + $dx;
    }
    $this->printTemplate($this->header_xobjid, $x, 0, 0, 0, '', '', false);
    if ($this->header_xobj_autoreset) {
        // reset header xobject template at each page
        $this->header_xobjid = false;
    }

   
}

public function Footer() {
   // $this->Cell(0, 10, "SEGMARIND SPA.", 0, false, "C", 0, "", 0, false, "T", "M");
   // $this->Cell(0, 10, "O´Higgins #840, Puerto Aysén", 0, false, "C", 0, "", 0, false, "T", "M");
  //  $this->Cell(0, 10, "www.segmarind.com     info@segmarind.com", 0, false, "C", 0, "", 0, false, "T", "M");

  $this->SetTextColor(77,77,77);
  $this->SetFont("", '', 6);
  $this->MultiCell(0,10, $this->InfoEmpresa , 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);
   
}
}
/* end Pdf.php file */