<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ReportAssignmentModels extends CI_Model
{
    
    private $Tabla = "movimientop";
    private $Delimitador= "|";
    private $Separador = "^";
    private $CamposTablas = ["movimientop.CodigoM","tienda.NombreT","producto.CodigoP","producto.Nombre","producto.Marca","producto.Modelo","movimientop.Existencia","movimientop.CostoD","movimientop.CostoM","movimientop.StopMinimo","producto.Clasificacion", "tienda.Codigo", "detallemov.Vencimiento"];
    private function InitJoin(){
        $this->db->join("tienda","movimientop.CodigoT = tienda.Codigo","LEFT",false);
        $this->db->join("producto","movimientop.CodigoP = producto.CodigoP","LEFT",false);
        $this->db->join("detallemov","movimientop.CodigoM = detallemov.CodigoMo AND  detallemov.Vencimiento = (SELECT Vencimiento FROM detallemov WHERE (movimientop.CodigoM = CodigoMo AND Vencimiento IS NOT NULL AND detallemov.CantidadActual > 0 )  ORDER BY detallemov.Vencimiento ASC
        LIMIT 1 ) ","LEFT",false);
        $this->db->where('movimientop.Status',$this->db->escape("Activo"),false); 
        $this->db->where('producto.Status',$this->db->escape("Activo"),false);
       }
    private function ValidarCdProducto($CD){
        $Res=  $this->db->get_where("producto",array("CodigoP"=>$CD))->result();
        if (count($Res) ===0){
            return $CD;
        }
        if ($Res[0]->Status === "Auxiliar"){
            return $Res[0]->CodigoAux;
        }
        return $CD;

    }
 



    private function Filtros($Filtros){
        $Filtros= str_replace('ø','/',$Filtros);
        $arr1 = explode($this->Delimitador,$Filtros);
        $array_num = count($arr1);
        for ($i = 0; $i < $array_num; ++$i){
           
            $posicion_coincidencia = strpos($arr1[$i], $this->Separador);
            if(  $posicion_coincidencia != FALSE ){
              $Array2 = explode($this->Separador,$arr1[$i]);
              $Array2[0]= $this->columna($Array2[0]);
              if($Array2[0]==="producto.CodigoP")
              {
                $Array2[1]= $this->db->escape($this->ValidarCdProducto($Array2[1]));
              }else{
                $Array2[1]= $this->db->escape($Array2[1]); 
              }
               
              $arr1[$i] =  $Array2;
            }else {
                $arr1[$i]= array("Todo", $arr1[$i]);
            }
        }
        return  $arr1;
    }

   
    private  function columna($id = null,$Mascara = false){
        $fields = $this->CamposTablas;
        if($id === null){
          
            $array_num = count($fields);
            for ($i = 0; $i < $array_num; ++$i){
                $fields[$i] =  $fields[$i]. " AS ". $this->Mascara($fields[$i]);
            }
            return $fields;

        }

        if(is_numeric($id)===false){
            $array_num = count($fields);
            for ($i = 0; $i < $array_num; ++$i){
                if($id === $fields[$i] ||  $this->Mascara($fields[$i]) === $id ){
                    if($Mascara=== false){
                        return $fields[$i];
                    }else{
                        return $fields[$i]. " AS ". $this->Mascara($fields[$i]);
                    }
                  
                }
              
            }
            return $fields[0];
        }else{

       

        if($Mascara === false){
            if(intval($id) < count($fields) && intval($id) > 0 ){
                return  $fields[intval($id)];
              }else{
                return $fields[0];
              }
        }else{
            if(intval($id) < count($fields) && intval($id) > 0 ){
                return  $fields[intval($id)]. " AS ". $this->Mascara($fields[intval($id)]);
              }else{
                return $fields[0]. " AS ". $this->Mascara($fields[0]);
              }        
        }
    }
       
    }
    private function Columnas($col = null,$Mascara = false){
          if($col=== null){
           $Arra =  $this->columna(null);
           return $Arra;
          }

        $Colu = substr($col, 1);
        $posicion_coincidencia = strpos($Colu, $this->Delimitador);
        if(  $posicion_coincidencia === FALSE ){
            $arr1 = str_split($Colu);
        }else{
            $arr1 = explode($this->Delimitador,$Colu);
        }
     
        $array_num = count($arr1);
        for ($i = 0; $i < $array_num; ++$i){
            $arr1[$i] =  $this->columna($arr1[$i],$Mascara);
        }
        return $arr1;
    }
    public function getReportAssignment($id=NULL)
    {
       
       if ($id === NULL){
        $this->db->distinct()->select($this->Columnas(),false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla)->result();
     
       }else{
          
           $Columna = $this->columna(0);
           $this->db->distinct()->select($this->Columnas(),false);
           $this->InitJoin();
           $this->db->where($this->Tabla.'.CodigoM',$this->db->escape("$id"),false);
           return  $this->db->get($this->Tabla)->result();

       }
       
    }
    public function getReportAssignmentLimite($Canti,$Desde){
        $this->db->distinct()->select($this->Columnas(),false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getReportAssignmentLimiteOrden($Canti,$Desde,$Columna,$Orden){
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
     
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        $this->db->distinct()->select($this->Columnas(),false);
        $this->InitJoin();
        $this->db->order_by($this->columna($Columna), $Direccion);
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getReportAssignmentLimiteOrdenColumnas($Canti,$Desde,$Columna,$Orden,$Columnas){
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        
       
     
        $this->db->distinct()->select($this->Columnas($Columnas,true),false);
        $this->InitJoin();
        $this->db->order_by($this->columna($Columna), $Direccion);
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getReportAssignmentIdColum($id,$Columnas){
       
        $this->db->distinct()->select($this->Columnas($Columnas,true),false);
        $Columna = $this->columna(0);
        $this->InitJoin();
        $this->db->where($Columna,$this->db->escape("$id"),false);
        return  $this->db->get($this->Tabla)->result();
    }
    public function getReportAssignmentLimiteColum($Canti,$Desde,$Columnas){
        $this->db->distinct()->select($this->Columnas($Columnas,true),false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getReportAssignmentFiltro($Filtros){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status =',"'Activo')",false ); 
        }
      
        $this->db->distinct()->select($this->Columnas(),false);
     return  $this->db->get($this->Tabla)->result();
      
    }
    private function total(){
        $this->db->distinct()->select("count(*) As Total",false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla)->result();
    }
    public function getReportAssignmentFiltroLimite($Filtros,$Canti,$Desde){
      
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status =',"'Activo')",false ); 
        }
        $this->db->distinct()->select($this->Columnas(),false);
     return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
    public function getReportAssignmentFiltroLimiteOrden($Filtros,$Canti,$Desde,$Columna,$Orden){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status =',"'Activo')",false ); 
        }
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        
       
     
        $this->db->distinct()->select($this->Columnas(),false);
     $this->db->order_by($this->columna($Columna), $Direccion);
     return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
    public function getReportAssignmentFiltroLimiteOrdenColumnas($Filtros,$Canti,$Desde,$Columna,$Orden,$Columnas){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status =',"'Activo')",false ); 
        }
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        
       
     
     $this->db->distinct()->select($this->Columnas($Columnas,true),false);
     $this->db->order_by($this->columna($Columna), $Direccion);
     return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
    public function getReportAssignmentFiltroColumnas($Filtros,$Columnas){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status =',"'Activo')",false ); 
        }
        $this->db->distinct()->select($this->Columnas($Columnas,true),false);

     return  $this->db->get($this->Tabla)->result();
      
    }

    public function getReportAssignmentFiltroLimitesColumnas($Filtros,$Canti,$Desde,$Columnas){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status =',"'Activo')",false ); 
        }
        $this->db->distinct()->select($this->Columnas($Columnas,true),false);

     return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
   
// desde aqui comianza la configuracion

    private function Mascara($Clave){
$ArrayReportAssignment["movimientop.CodigoM"]=  utf8_encode('Código');
$ArrayReportAssignment["movimientop.CostoM"]=  utf8_encode('Precio_Mayor');
$ArrayReportAssignment["movimientop.CostoD"]= utf8_encode("Precio");
$ArrayReportAssignment["movimientop.CantidadM"]="Cantidad_Minima_Al_Mayor";
$ArrayReportAssignment["producto.CodigoP"]= 'Producto';
$ArrayReportAssignment["producto.Nombre"]= 'Nombre';
$ArrayReportAssignment["producto.Marca"]= 'Marca';
$ArrayReportAssignment["producto.Modelo"]= 'Modelo';
$ArrayReportAssignment["producto.Modelo"]= 'Modelo';
$ArrayReportAssignment["tienda.NombreT"]="Tienda" ;
$ArrayReportAssignment["movimientop.Existencia"]= "Existencia";
$ArrayReportAssignment["movimientop.iva"]= "iva";
$ArrayReportAssignment["movimientop.StopMinimo"]= "Stock_Minimo";
$ArrayReportAssignment["movimientop.charge"]= "Pedidios";
$ArrayReportAssignment["movimientop.StopMax"]= utf8_encode('Stock_Maximo');
$ArrayReportAssignment["producto.Clasificacion"]= utf8_encode('Clasificación');
$ArrayReportAssignment["tienda.Codigo"]= utf8_encode('IdTienda');
$ArrayReportAssignment["detallemov.Vencimiento"]= utf8_encode('Vence');


$ArrayReportAssignment["movimientop.Status"]= "Status";
if (isset($ArrayReportAssignment[$Clave])){
return $ArrayReportAssignment[$Clave];
}else{
return $Clave;
}
}

    private function verificarExistencia($dato,$Array)
    {
        $array_num = count($Array);
        for ($id = 0; $id < $array_num; ++$id){
            if($Array[$id]["nombre"] == $dato){
              return $id;
            }
        }
        return false;
    }






   Public function MetaData($Mascara = true){



return  null;

} 

}
